// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit

class TableViewCell: UITableViewCell {
    @IBOutlet private weak var title: UILabel!
    @IBOutlet private weak var button: UIButton!
    
    private var action: (() -> Void)?
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        button.layer.cornerRadius = 3
    }

    // MARK: Setter
    func setTitle(_ text: String) {
        title.text = text
    }
    
    func setButtonTitle(_ text: String) {
        button.setTitle(text, for: .normal)
    }
    
    func setButtonAction(_ action: @escaping () -> Void) {
        self.action = action
    }
    
    func setCellIndex(_ row: Int) {
        let btIdentifier = "btn_mm_\(row)"
        button.accessibilityIdentifier = btIdentifier
        button.accessibilityLabel = btIdentifier
    }
    
    // MARK: IBAction
    @IBAction func onActionButtonClick(_ sender: Any) {
        action?()
    }
}
